/** @file   particleglass.h
 * @brief   Declaration of ParticleGlass - class.
 * @version $Revision: 1.2 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_ENG2D_PARTICLEGLASS_H
#define H_ENG2D_PARTICLEGLASS_H

#include "eng2d_dll.h"
#include "particlesystem.h"

namespace eng2d {


/** @class  ParticleGlass
 * @brief   Reprensents a particle effect of breaking glass.
 * @author  Tomi Lamminsaari
 *
 */
class DLLIMPORT ParticleGlass : public ParticleSystem
{
public:

  ///
  /// Constants, datatype and static members
  /// ======================================

  /** The average time the particles will live. */
  static int s_averageLifetime;

  ///
  /// Constructors, destructor and operators
  /// ======================================

	/** Constructor.
   */
	ParticleGlass( const Vec2D& rP, const Vec2D& rD, int num );


	/** Destructor
   */
	virtual ~ParticleGlass();

private:
  ParticleGlass( const ParticleGlass& rO );
  ParticleGlass& operator = ( const ParticleGlass& rO );
public:
};

};  // end of namespace

#endif
